const express = require("express");
const connectDB = require("./config/db");
const { errorHandler } = require("./middlewares/error");
const cors = require("cors");
const https = require("https");
const fs = require("fs");
const path = require("path");

const multer = require("multer");

const User = require("./models/User");
require("dotenv").config();

connectDB();

const app = express();

const PORT = process.env.PORT || 6000;

app.use(cors());
app.get('/',(req,res)=>{
  res.send("Server is working")
})

app.all('/', function(req, res, next) {
  res.header("Access-Control-Allow-Origin", "*");
  res.header("Access-Control-Allow-Headers", "X-Requested-With");
  next();
});

app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use("/uploads", express.static(path.join(__dirname, "uploads")));


// Multer Storage Configuration
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
      cb(null, "uploads/userImages");
  },
  filename: (req, file, cb) => {
      cb(null, Date.now() + path.extname(file.originalname)); // Unique filename
  }
});

const upload = multer({ storage });

// Upload Route
app.post("/upload/:userId", upload.single("image"), async (req, res) => {
  try {
    
    const userId = req.params.userId;
      if (!req.file) {
          return res.status(400).json({ error: "No file uploaded" });
      }

      const imagePath = `${req.protocol}://${req.get("host")}/uploads/userImages/${req.file.filename}`;

      const user = await User.findByIdAndUpdate(userId, { userImage: imagePath }, { new: true });
      if (!user) {
          return res.status(404).json({ error: "User not found" });
      }

      res.json({ message: "File uploaded successfully", imagePath });
  } catch (error) {
      console.error(error);
      res.status(500).json({ error: "Internal Server Error" });
  }
});


formdataParser = upload.single("image");
app.use(formdataParser);

app.use("/api/auth", require("./routes/auth"));

app.use(errorHandler);

const privateKeyPath = '../ssl/keys/a8004_eb92b_0ce18342376a6bb8d28be6d9cdcfd46f.key';
const certificatePath = '../ssl/certs/_wildcard__wurknest_com_a8004_eb92b_1753410359_195db1d9090959231087e3736e50da91.crt';
const privateKey = fs.readFileSync(privateKeyPath, 'utf8');
const certificate = fs.readFileSync(certificatePath, 'utf8');
const credentials = { key: privateKey, cert: certificate };

const server = https.createServer(credentials, app);

server.listen(PORT, () => {
  console.log(`Server started listening on ${PORT}`);
});
// app.listen(PORT, () => {
//   console.log(`Server started listening on ${PORT}`);
// });

process.on("unhandledRejection", (error, promise) => {
  console.log(`Logged Error: ${error}`);
  server.close(() => process.exit(1));
});
