const mongoose = require("mongoose");
const bcryptjs = require("bcryptjs");
const jwt = require("jsonwebtoken");
const crypto = require("crypto");

const businessSchema = new mongoose.Schema({
  businessName : { 
   type: String,
   default: ""
  },
  numberOfEmployees :{
    type: String,
    default: ""
  },
  region: { 
   type: String,
   default: ""
  },
  domain : { 
   type: String,
   default: ""
  },
  streetAddress:{ 
   type: String,
   default: ""
  },
  streetAddressLine2:{ 
   type: String,
   default: ""
  },
  city:{ 
   type: String,
   default: ""
  },
  LocalGovernmentArea:{ 
   type: String,
   default: ""
  },
      postalCode:{ 
   type: String,
   default: ""
  },
      state:{ 
   type: String,
   default: ""
  },
  businessPhoneNumber:{
     type: Number,
   },
});

const userSchema = mongoose.Schema(
  {
    firstName: {
      type: String,
      required: [true, "Please provide a firstName"],
    },
    lastName: {
      type: String,
      required: [true, "Please provide a lastName"],
    },
    username: {
      type: String,
      required: [true, "Please provide a username"],
    },
    email: {
      type: String,
      required: [true, "Please provide an email"],
      unique: true,
      match: [
        /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/,
        "Please provide a valid email",
      ],
    },
    recoveryEmail:{
      type: String,
      required: [true, "Please provide an recovery Email"],
      unique: true,
      match: [
        /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/,
        "Please provide a valid email",
      ],
    },
    session :{
       type : Boolean,
    },
    phoneNumber:{
      type: Number,
    },
    gender: {
      type: String,
    },
    dob: {
      type: String,
    },
    accountType: {
      type: String,
      required: [true, "Please provide an accountType"],
    },
    password: {
      type: String,
      required: [true, "Please provide a password"],
      minlength: 6,
      select: false,
    },
    role: {
      type: String,
      required: true,
      default: "user",
      // subscriber, author, and admin (suspended)
    },
    registerIpAddress: {
      type: String,
      default: "",
    },
    referred_by :{ 
      type: String,
      default: ""
    },
    isVerified: {
      type: Boolean,
      default: false,
    },
    business: {
    type: businessSchema,
    default: null
     },
    resetPasswordToken: String,
    resetPasswordExpire: Date,


  },
  {
    timestamps: true,
  }
);



userSchema.pre("save", async function (next) {
  if (!this.isModified("password")) {
    next();
  }

  const salt = await bcryptjs.genSalt(10);
  this.password = await bcryptjs.hash(this.password, salt);
  next();
});

userSchema.methods.matchPasswords = async function (password) {
  return await bcryptjs.compare(password, this.password);
};

userSchema.methods.getSignedToken = function () {
  return jwt.sign({ id: this._id }, process.env.JWT_SECRET, {
    expiresIn: "1h",
  });
};

userSchema.methods.getSignedToken = function () {
  return jwt.sign({ id: this._id }, process.env.JWT_SECRET, {
    expiresIn: "1h",
  });
};

userSchema.methods.getRefreshToken = function () {
  return jwt.sign({ id: this._id , email:this.email }, process.env.JWT_REFRESH_SECRET, {
    expiresIn: "2d",
  });
};

userSchema.methods.getSessionToken = function () {
  return jwt.sign({ id: this._id , email:this.email }, process.env.JWT_REFRESH_SECRET, {
    expiresIn: "7d",
  });
};

userSchema.methods.getResetPasswordToken = function () {
  const resetToken = crypto.randomBytes(20).toString("hex");
  this.resetPasswordToken = crypto
    .createHash("sha256")
    .update(resetToken)
    .digest("hex");
  this.resetPasswordExpire = Date.now() + 60 * (60 * 1000);
  return resetToken;
};

module.exports = mongoose.model("User", userSchema);
